import { useState, useEffect } from 'react';

function useWindowDimensions() {
  const hasWindow = typeof window === 'object';

  function getWindowDimensions() {
    const width = hasWindow ? window.innerWidth : undefined;
    const height = hasWindow ? window.innerHeight : undefined;

    return {
      width,
      height
    };
  }

  const [windowDimensions, setWindowDimensions] = useState(getWindowDimensions);

  useEffect(() => {
    if (!hasWindow) {
      return;
    }

    function handleResize() {
      setWindowDimensions(getWindowDimensions());
    }

    window.addEventListener('resize', handleResize);
    return () => window.removeEventListener('resize', handleResize); /* eslint-disable react-hooks/exhaustive-deps */
  }, []);

  return windowDimensions;
}

export { useWindowDimensions };
