let AUTH_URL = 'https://auth.amp.xarth.tv/worker/auth';
let ATLAS_BASE_URL = 'https://service.atlas.xarth.tv';
let ATLAS_URL = 'https://service.atlas.xarth.tv/worker/atlas';

const staging = document.location.hostname === 'atlas.cursedata.io' || process.env.REACT_APP_ENVIRONMENT === "staging";
const development = document.location.hostname === 'localhost' || process.env.REACT_APP_ENVIRONMENT === "development";

// Staging can override development, with proper environment flag
if (staging) {
  AUTH_URL = 'https://auth.resonance.cursedata.io/worker/auth';
  ATLAS_BASE_URL = 'https://service.atlas.cursedata.io';
  ATLAS_URL = 'https://service.atlas.cursedata.io/worker/atlas';
} else if (development) {
  AUTH_URL = 'http://localhost:8084/worker/auth';
  ATLAS_BASE_URL = 'http://localhost:8087';
  ATLAS_URL = 'http://localhost:8087/worker/atlas';
}


export const ATLAS_ROUTES = ['Overview', 'Products', 'Seasons', 'Events', 'Contracts'];

export const EVENT_ROUTES = [
  { label: 'All', linkTo: '/events' },
  { label: 'Channel', linkTo: '/events/channel' },
  { label: 'Category', linkTo: '/events/category' }
];

export const NAV_HEIGHT = 50;
export const MODAL_HEADER_AND_FOOTER_HEIGHT = '150px';

export { ATLAS_BASE_URL, ATLAS_URL, AUTH_URL };