import { fetchData } from "./fetch";
import { downloadTextFile } from "./helpers";

interface GetEventCSVByPCCResult {
    data?: string;
}

/**
 * Exports a CSV of the current PCC's event list. This is sourced
 * from the service data, not based on the current table listing. 
 * @param pccId Numerical id of PCC whose data to csv export
 */
export async function csvExportEventList(pccId: number) {
    if (!pccId) {
        console.error("No PCC selected; could not export listing");
        return;
    }

    try {
        const result = await fetchData<GetEventCSVByPCCResult>(`event/get-event-csv-by-pcc/${pccId}`, "GET", {});
        if (result?.data) {
            // base64 decode the response
            const text = atob(result.data);
            downloadTextFile(text, "events.csv");
        } else {
            console.error(`No CSV data found for PCC ${pccId}`);
        }
    } catch (err) {
        console.error("Failed to export CSV file", err);
    }
}
