import Cookies from 'js-cookie';
import { ATLAS_BASE_URL } from './config';
import { fetchWithTimeout } from './helpers';

export async function fetchData<T>(path: string, method: 'GET' | 'POST', body?: any): Promise<T | null> {
    let token = Cookies.get('token');

    let bodyFormatted = undefined;
    if (method !== 'GET') {
      bodyFormatted = Object.keys(body ?? {})
      .filter(e => body[e] !== null)
      .reduce((o, e) => {
        o[e] = body[e];
        return o;
      }, {});
      bodyFormatted = JSON.stringify(bodyFormatted);
    }

    const options = {
      method,
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/json',
        Authorization: `Bearer ${token}`
      },
      body: bodyFormatted
    };
    const url = `${ATLAS_BASE_URL}/${path}`;
    try {
        const response = await fetchWithTimeout(url, options);
        const json = await response.json();
        console.log(path, json);
        return json as T;
    }catch (err) {
        console.error(`Error fetching url: ${url}`, err);
    }

    return null;
}
