import { fuzzySelect, simplify } from './fuzzySearch';

const values = ["Sim Tower", "Sim City", "Spore", "Sim Ant", "The Sims"];
const values2 = ["Exhibition / Showmatch", "IRL", "Regular Season", "Tournament / Playoffs / Finals", , "Tournament Qualifier / Playoff Qualifier"];

const formats = [ "Convention", "Developer Gaming Stream", "Developer Studio Stream", "Pre-Produced Promotional Content", "Talk ShOw", "Twitch Plays" ];
const formats2 = [ "Convention", "Developer Gaming Stream", "Developer Studio Stream", "Pre-Produced Promotional Content", "Talk ShOw - Mixed MeDia!", "Twitch Plays" ];

describe("FuzzySearch", () => {
    it("picks the best option of many", () => {
        expect(fuzzySelect("sm ant", values)).toBe("Sim Ant");
        expect(fuzzySelect("sim tow", values)).toBe("Sim Tower");
        expect(fuzzySelect("sim spore", values)).toBe("Spore");
    });

    it("returns null for unexisting results", () => {
        expect(fuzzySelect("Moral Combat", values)).toBe(null);
    });

    it("properly checks spaces", () => {
        expect(fuzzySelect("Tournament/Playoffs/Finals", values2)).toBe("Tournament / Playoffs / Finals");
    });

    it("properly does substring backup checks", () => {
        // These close values have been known to fail the check
        expect((fuzzySelect("Talk show - mixed Media ", formats))).toBe("Talk ShOw");
        expect((fuzzySelect("Talk  show! ", formats2))).toBe("Talk ShOw - Mixed MeDia!");

    });
});

describe("Simplify", () => {
    it ("Removes all symbols and spaces and makes it lowercase", () => {
        expect(simplify(" A bc 123 HiJ !# ^ ( )_  q \n R r ")).toBe("abc123hijqrr");
    })
});
