

/**
 * Result of GetUsers query. 
 */
export interface GetUsersQueryResult {
    users?: (GQLChannel | null)[];
}

/**
 * User type fields for User queries.
 */
export interface GQLChannel {
    id?: string;
    login?: string;
    displayName?: string;
    profileImageURL?: string;
}

/**
 * Combination of channels that were found or not found
 * from getChannels request.
 */
export interface GetChannelsResults {
    results: GQLChannel[];
    notFound: string[];
}

/**
 * Single category for a the SearchCategories query.
 */
export interface Category {
    name?: string;
    channelsCount?: number;
    viewersCount?: number;
    avatarURL?: string;
}

/**
 * Result of the SearchCategories query.
 */
export interface SearchCategoriesQueryResult {
    searchCategories: {
            edges: {
            node: Category;
        }[],
    }
}

/**
 * Results of the SearchCategories context provider request.
 */
 export interface SearchCategoriesResults {
    categories: Category[];
}

/**
 * Results for SearchUsersQuery
 */
export interface SearchUsersQueryResults {
    searchUsers: {
            edges: {
            node: (GQLChannel | null);
        }[]
    }
}

/**
 * Input for SearchUsersQuery
 */
export interface SearchUsersQueryInputs {
    userQuery: string;
}
