/**
 * Data for imported events, such as from CSVs. All values
 * are strings.
 */
export interface EventImportData {
    event_name?: string;
    start_time?: string;
    end_time?: string;
    topic?: string;
    format?: string;
    game_name?: string;
    event_type?: string;
    estimated_average_ccv?: string;
    is_active?: string;
    distribution?: string;
    costreaming_settings?: string;
    product_name?: string;
  
    /**
     * semicolon-delimitted list of channel logins. No spaces.
     */
    channel_names?: string;

    /**
     * Alternative to game_name 
     */
    category?: string;

    /**
     * Alternative to distribution
     */
    exclusivity?: string;
}

/**
  * CSV parsing will fail if these headers are not included; these are the minimal
  * required headers for CSV parsing to succeed.
  */
export const requiredEventImportHeaders: (keyof EventImportData)[] = [
    "event_name",
    "product_name",
    "start_time",
    "end_time",
];

/**
 * Headers that will be parsed from CSV. Note that these may differ
 * from the actually rendered columns in the tables.
 */
export const allowedEventImportHeaders: (keyof EventImportData)[] = [
    "event_name",
    "product_name",
    "start_time",
    "end_time",
    "topic",
    "format",
    "costreaming_settings",
    "estimated_average_ccv",
    "distribution",
    "channel_names",
    "category",

    // alternative for category
    "game_name",
    
    // alternative for distribution
    "exclusivity",
];
