export const languageOptions = [
  { value: 'en', label: 'English' },
  { value: 'pt', label: 'Português' },
  { value: 'ko', label: 'Korean (한국어)' },
  { value: 'tr', label: 'Turkish' },
  { value: 'es', label: 'Español (Spanish)' },
  { value: 'fr', label: 'French (Français)' },
  { value: 'sv', label: 'Swedish (Svenska)' },
  { value: 'fi', label: 'Finnish' },
  { value: 'other', label: 'Other' },
  { value: 'cs', label: 'Czech' },
  { value: 'bg', label: 'Bulgarian' },
  { value: 'no', label: 'Norwegian' },
  { value: 'nl', label: 'Dutch; Flemish' },
  { value: 'ja', label: 'Japanese (日本語)' },
  { value: 'ru', label: 'Russian (Pусский)' },
  { value: 'da', label: 'Danish' },
  { value: 'it', label: 'Italiano (Italian)' },
  { value: 'pl', label: 'Polish (Polski)' },
  { value: 'de', label: 'German (Deutsch)' },
  { value: 'zh', label: 'Chinese (Simplified)' },
  { value: 'ar', label: 'Arabic' },
  { value: 'zh-hk', label: 'Chinese (Hong Kong)' },
  { value: 'el', label: 'Greek (Ελληνικά)' },
  { value: 'hu', label: 'Hungarian' },
  { value: 'id', label: 'Indonesian (Bahasa Indonesia)' },
  { value: 'ro', label: 'Romanian' },
  { value: 'ca', label: 'Catalan; Valencian' },
  { value: 'sk', label: 'Slovak' },
  { value: 'th', label: 'Thai' },
  { value: 'vi', label: 'Vietnamese' },
  { value: 'uk', label: 'Ukrainian' },
  { value: 'tl', label: 'Tagalog' },
  { value: 'hi', label: 'Hindi' }
];

export const adOptions = [
  { name: 'ads', label: 'Standard Agreement ($3.50 cpm / $3.50 cpm / 50% split)', value: 'Standard' },
  { name: 'ads', label: 'Premium Agreement ($5.00 cpm / $3.50 cpm / 50% split)', value: 'Premium' },
  { name: 'ads', label: '50/50 Agreement (50% Partner, 50% Twitch)', value: 'Equal Split' },
  { name: 'ads', label: 'Custom Agreement', value: 'Custom' },
  { name: 'ads', label: 'None', value: 'None' }
];

export const tier1Options = [
  { name: 'tier1', label: 'CPM', value: 'cpm' },
  { name: 'tier1', label: 'Percentage', value: '% of net' }
];

export const tier2Options = [
  { name: 'tier2', label: 'CPM', value: 'cpm' },
  { name: 'tier2', label: 'Percentage', value: '% of net' }
];

export const tier3Options = [
  { name: 'tier3', label: 'CPM', value: 'cpm' },
  { name: 'tier3', label: 'Percentage', value: '% of net' }
];

export const monthOptions = [
  { value: 0, label: 'January' },
  { value: 1, label: 'February' },
  { value: 2, label: 'March' },
  { value: 3, label: 'April' },
  { value: 4, label: 'May' },
  { value: 5, label: 'June' },
  { value: 6, label: 'July' },
  { value: 7, label: 'August' },
  { value: 8, label: 'September' },
  { value: 9, label: 'October' },
  { value: 10, label: 'November' },
  { value: 11, label: 'December' }
];

export const channelTypeOptions = [
  'PCC Owned - Primary',
  'PCC Owned - Supplemental',
  '3rd Party (non-UGC) - Supplemental',
  'Co-Stream - Authorized / Official',
  'UGC Participant',
  'Co-Stream - Organic',
  'UGC Host'
];

export const contentCreatorTypeOptions = [
  'Esports, Publisher / Developer',
  'Esports, Tournament Organizer',
  'Esports, Indie / Community / Other',
  'Esports, First Party',
  'Esports, Re-Organizer / Dedicated Co-streaming Org',
  'First Party, Other',
  'Games, Publisher/Developer',
  'Sports, Semi-Pro / Collegiate',
  'Sports, Amateur / Pre-Collegiate / Other',
  'Sports, Professional League',
  'Music Producer / Studio / Record Label',
  'Media Distributor',
  'News, Journalism, New Media',
  'Content Shop, Comedy',
  'Content Shop, Other',
  'Other'
];

export const twitchInvolvementOptions = ['(None)', 'Co-Produced', 'O&O', 'Go-to-Market Support'];

export const coStreamingSettingsOptions = ['Not allowed', 'Invite only (from Broadcaster)', 'Yes - Open'];

export const checkboxOptions = [
  { label: 'Exclusive to Twitch', value: 'true' },
  { label: 'Non-Exclusive', value: 'false' }
];

export const timezoneOptions = [
  { name: '(GMT -12:00) Eniwetok, Kwajalein', value: 'Dateline Standard Time', offset: '-12:00', DST: false },
  { name: '(GMT -11:00) Midway Island, Samoa', value: 'Samoa Standard Time', offset: '-11:00', DST: false },
  { name: '(GMT -10:00) Hawaii', value: 'Hawaiian Standard Time', offset: '-10:00', DST: false },
  { name: '(GMT -9:00) Alaska', value: 'Alaskan Standard Time', offset: '-09:00', DST: true },
  { name: '(GMT -8:00) Pacific Time (US & Canada)', value: 'Pacific Standard Time', offset: '-08:00', DST: true },
  { name: '(GMT -7:00) Mountain Time (US & Canada)', value: 'Mountain Standard Time', offset: '-07:00', DST: true },
  { name: '(GMT -6:00) Central Time (US & Canada), Mexico City', value: 'Central Standard Time', offset: '-06:00', DST: true },
  { name: '(GMT -5:00) Eastern Time (US & Canada), Bogota, Lima', value: 'US Eastern Standard Time', offset: '-05:00', DST: true },
  { name: '(GMT -4:00) Atlantic Time (Canada), Caracas, La Paz', value: 'Atlantic Standard Time', offset: '-04:00', DST: true },
  { name: '(GMT -3:00) Brazil, Buenos Aires, Georgetown', value: 'E. South America Standard Time', offset: '-03:00', DST: true },
  { name: '(GMT -2:00) Mid-Atlantic', value: 'Mid-Atlantic Standard Time', offset: '-02:00', DST: true },
  { name: '(GMT -1:00) Azores, Cape Verde Islands', value: 'Azores Standard Time', offset: '-01:00', DST: true },
  { name: '(GMT) Western Europe Time, London, Lisbon, Casablanca', value: 'GMT Standard Time', offset: '+00:00', DST: true },
  { name: '(GMT +1:00) Brussels, Copenhagen, Madrid, Paris', value: 'Romance Standard Time', offset: '+01:00', DST: true },
  { name: '(GMT +2:00) Kaliningrad, South Africa', value: 'GTB Standard Time', offset: '+02:00', DST: true },
  { name: '(GMT +3:00) Baghdad, Riyadh, Moscow, St. Petersburg', value: 'Arabic Standard Time', offset: '+03:00', DST: true },
  { name: '(GMT +4:00) Abu Dhabi, Muscat, Baku, Tbilisi', value: 'Arabian Standard Time', offset: '+04:00', DST: false },
  { name: '(GMT +5:00) Ekaterinburg, Islamabad, Karachi, Tashkent', value: 'Pakistan Standard Time', offset: '+05:00', DST: true },
  { name: '(GMT +5:30) Bombay, Calcutta, Madras, New Delhi', value: 'India Standard Time', offset: '+05:30', DST: false },
  { name: '(GMT +6:00) Almaty, Dhaka, Colombo', value: 'Central Asia Standard Time', offset: '+06:00', DST: false },
  { name: '(GMT +6:30) Yangon, Mandalay', value: 'Myanmar Standard Time', offset: '+06:30', DST: false },
  { name: '(GMT +7:00) Bangkok, Hanoi, Jakarta', value: 'SE Asia Standard Time', offset: '+07:00', DST: false },
  { name: '(GMT +8:00) Beijing, Perth, Singapore, Hong Kong', value: 'China Standard Time', offset: '+08:00', DST: false },
  { name: '(GMT +9:00) Tokyo, Seoul, Osaka, Sapporo, Yakutsk', value: 'Tokyo Standard Time', offset: '+09:00', DST: false },
  { name: '(GMT +10:00) Eastern Australia, Guam, Vladivostok', value: 'AUS Eastern Standard Time', offset: '+10:00', DST: true },
  { name: '(GMT +11:00) Magadan, Solomon Islands, New Caledonia', value: 'Central Pacific Standard Time', offset: '+11:00', DST: false },
  { name: '(GMT +12:00) Auckland, Wellington, Fiji, Kamchatka', value: 'New Zealand Standard Time', offset: '+12:00', DST: true },
  { name: '(GMT +13:00) Apia, Nukualofa', value: 'Tonga Standard Time', offset: '+13:00', DST: true }
];

export const channelOwnershipOptions = ['Owned & Operated', 'UGC', '3rd Party Premium'];

export const channelVerticalOptions = ['Esports', 'Music', 'Sports', 'Podcasts', 'None'];
