// Code referenced from https://www.jayfreestone.com/writing/react-portals-with-hooks/

import * as React from 'react';
import { createPortal } from 'react-dom';
import usePortal from '../hooks/usePortal';

export enum PortalType {
    Modal = "modal",
}

interface Props {
    type?: PortalType
}

/**
 * @example
 * <Portal id="modal">
 *   <p>Thinking with portals</p>
 * </Portal>
 */
export const Portal: React.FC<Props> = (props) => {
  const target = usePortal(props.type || PortalType.Modal);
  return createPortal(
    props.children,
    target,
  );
};

export default Portal;
