import { Moment } from "moment";

export interface WorkspaceEvent extends AtlasEvent {
  workspace_id?: string;
}
export interface AtlasEvent {
  event_id?: number;
  season_id: number;
  product_id: number;
  event_name: string;
  premium_content_creator_id: number;
  start_time: string | Moment;
  end_time: string | Moment;
  topic: string;
  sub_topic: string;
  format: string;
  sub_format: string;
  game_name: string;
  event_type: string;
  estimated_average_ccv: number;
  pledged_hours_broadcast: number;
  is_active: boolean;
  distribution: boolean;
  twitch_involvement: string;
  costreaming_settings: string;
  season_name: string;

  product_name: string;
  channels?: Channel[];
  channel_count?: number;
}

export interface Season {
  season_id: number;
  season_name: string;
  product_id: number;
  product_name: string;
  start_time: string;
  end_time: string;
  pledged_hours_broadcast: number;
  prize_pool: number;
  previous_season_id: null;
  previous_season_name: string;
  is_active: number;
}

export interface Product {
  product_id: number;
  product_name: string;
  product_description: string;
  product_owner: string;
  topic: string;
  sub_topic: string;
  format?: string | null;
  sub_format?: string | null;
  is_active: boolean;
  count_of_channels: number;
  count_of_upcoming_events: number;
  contract_id: string;
  premium_content_creator_id: number;
  front_page_asset: string;
}

export interface Contract {
  contract_id?: number;
  contract_name: string;
  premium_content_creator_id: number;
  account_manager_map_id: number;
  start_date: string;
  end_date: string;
  contract_type: string;
  exclusivity_enabled: boolean;
  ad_prerolls_enabled: boolean;
  sponsorship_enabled: boolean;
  revenue_share_enabled: boolean;
  ad_revenue_contract_type: string;
  ad_revenue_share_type_tier_1: string;
  ad_revenue_share_amount_tier_1: number;
  ad_revenue_share_type_tier_2: string;
  ad_revenue_share_amount_tier_2: number;
  ad_revenue_share_type_tier_3: string;
  ad_revenue_share_amount_tier_3: number;
  bits_revenue_share_percent: number;
  subs_revenue_share_percent: number;
  ad_density_per_hour?: number;
  is_active?: boolean;
}

export interface Format {
  format: string;
  format_id: number;
}

export interface TopicOptions {
  topic: string;
  topic_id: number;
  formats: Format[];
}

export interface Channel {
  channel_id: number;
  channel_login: string;
  profile_image?: string;
  channel_type?: string;
  event_id?: number;

  // These seem to be start/end dates for contracts
  // TODO: remove once contracts fully removed
  custom_start_date?: Date;
  custom_end_date?: Date;
}
