#!/bin/sh

: ${1?Need a domain value}

# Grant permissions to Jenkins
git add --chmod=+x "./upload-script.sh"

# Save a short git hash, must be run from a git repository (or a child directory)
version=$(git rev-parse --short HEAD)

# Use the post_server_time access token, you can find one in your project access token settings
post_server_item=2a16850c78994c139e4284da42d4da6f

echo "Uploading source maps for version $version!"

# We upload a source map for each resulting JavaScript file; the path depends on your build config
for path in $(find build/static/js -name "*.js"); do
  # URL of the JavaScript file on the web server
  url=//$1/${path}

  # a path to a corresponding source map file
  source_map="@$path.map"

  echo "Uploading source map for $url"

  curl --silent --show-error https://api.rollbar.com/api/1/sourcemap \
    -F access_token=$post_server_item \
    -F version=$version \
    -F minified_url=$url \
    -F source_map=$source_map \
    > /dev/null
done
