# Achievements

[![Build Status](https://jenkins-og.xarth.tv/buildStatus/icon?job=cb-achievements-build)](https://jenkins-og.xarth.tv/job/cb-achievements-build)

Achievements is a project for incentivizing content creators and rewarding them for their efforts.

## Service Resources
| Resource            |
|---------------------|
| [Runbook](./docs/runbook.md) |
| [Dashboard](https://grafana.xarth.tv/d/000001322/achievements?var-Datasource_graphite=grafanacloud-prodeng-graphite)       | 
| [Slack](https://twitch.slack.com/archives/C2VA4EXN0)           |
| [Pagerduty](https://twitchoncall.pagerduty.com/services/P91KRCI)       |
| [Service Catalog](https://catalog.xarth.tv/services/160/details) |
| [SLA](/docs/service_level_agreement.md) | 
| [Jenkins Build](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-achievements-build/) |
| [Jenkins Deploy](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-achievements-deploy/) |
| [Rollbar Logs](https://rollbar.com/Twitch/CB_Achievements/items) |
| [API](https://wiki.twitch.com/display/CB/Achievements+API) |
| [Wiki](https://wiki.twitch.com/display/CB/Achievements) |

Please consult the [docs](./docs) for more details, including design and architecture choices.

## Table of Contents
1. [Service Links](#service-links)
2. [Usage](#usage)
3. [Development](#development)
    1. [Setup](#setup)
    2. [Testing](#testing)
    3. [Dependencies](#dependencies)
    4. [Running locally](#running-locally)
    5. [Scheduled Jobs](#scheduled-jobs)
    6. [Working with Redshift](#working-with-redshift)

## Service Links
| Environment | AWS Account | DNS Name |
|-------------|-------------|----------|
| staging     | [twitch-cb-aws](https://twitch-cb-aws.signin.aws.amazon.com/console) | http://staging.achievements.cb.twitch.a2z.com |
| production  | [twitch-cb-aws](https://twitch-cb-aws.signin.aws.amazon.com/console) | http://prod.achievements.cb.twitch.a2z.com |

## Usage
There are two clients available, an external client and an internal client. To integrate with Achievements in your project, use the internal client:
```go
achievementsClient, err := achievementsinternal.NewClient(twitchhttp.ClientConf{
    Host: "achievements-staging-or-prod-host",
    // additional twitch client configuration
})
```

The external client is intended for use in Visage only. If you wish to use it, you can find the implementation [here](https://git.xarth.tv/cb/achievements/tree/master/client/achievements).

## Development

### Setup

To setup your machine (macOS) for local development, run the following command:

```
make setup
```

The above command runs the following in sequence:

1. `make setup-linter`: Installs [Golanci-lint](https://github.com/golangci/golangci-lint).

2. `make setup-migrate`: Installs [migrate CLI](https://github.com/mattes/migrate/tree/master/cli).

3. `make setup-psql`: Installs PostgresQL via [Homebrew](https://brew.sh/).

4. `make setup-db`: Creates the Achievements database (PostgresQL) and runs the schema migration locally.

### Testing

`make lint`: Runs the linter. Configuration for the linter can be found in [.golangci.yml](https://git.xarth.tv/cb/achievements/blob/master/.golangci.yml).

`make mocks`: Generates mocks for testing using [mockery](https://github.com/vektra/mockery).

`make test`: Runs all unit tests.

### Dependencies

[Dep](https://golang.github.io/dep/) is used for pinning package versions and updating dependencies.

To add or update a dependency, edit [`Gopkg.toml`](./Gopkg.toml) and run `make update`

### Running locally

- For Go versions 1.13 and greater, prepend `make` commands with `GO111MODULE=off`

- `make dev-affiliate-worker`: starts the `affiliates` engine

- Running `api` locally: 

     * Run `pg_ctl -D /usr/local/var/postgres -l /usr/local/var/postgres/server.log start` to start local PostgresQL server. 

     * Run `make setup-db` afterwards to setup the schema locally.
      
     * `make dev-api` starts the API on localhost.

     * Close out the local PostgresQL server with `pg_ctl -D /usr/local/var/postgres -l /usr/local/var/postgres/server.log stop` once testing is complete.


- `make dev-sourcer`: runs the `sourcer` engine

- `make dev-worker`: runs the `worker`

- `make dev-quests`: starts the `quests` engine

For more details on what these packages do and how they are architected, consult the [docs](./docs).

### Scheduled Jobs

Many achievements are set up as cron scheduled jobs running in an Elastic Beanstalk environment. For details on how these work, consult the documentation on [periodic tasks](http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/using-features-managing-env-tiers.html#worker-periodictasks).

### Working With Redshift

- [Developing with Redshift](./docs/redshift.md)

- [Ingesting a new event](./docs/new_event.md)

### Connecting to Achievements

To connect to Achievements, add your principal to the list of allowed principals in `terraform/production/main.tf` and `terraform/staging/main.tf` under `vpc_endpoint_service_allowed_principals`.

Then, use the following VPCE and DNS endpoints.

| Environment | VPCE | DNS Name |
|-------------|-------------|----------|
| staging     | `com.amazonaws.vpce.us-west-2.vpce-svc-0438c14685b080b3e` | http://staging.achievements.cb.twitch.a2z.com |
| production  | `com.amazonaws.vpce.us-west-2.vpce-svc-004e22b5d2db86723` | http://prod.achievements.cb.twitch.a2z.com |

### Terraform

```bash
$ AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-cb-aws terraform plan
$ AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-cb-aws terraform apply
```
