-- quest status
CREATE TABLE IF NOT EXISTS quest_achievement_ranking_statuses(
  id uuid PRIMARY KEY DEFAULT uuid_generate_v4(),
  channel_id varchar(255) NOT NULL,
  quest_achievement_ranking_id uuid REFERENCES quest_achievement_rankings (id) NOT NULL,

  created_at_utc timestamp DEFAULT current_timestamp NOT NULL,
  updated_at_utc timestamp,

  CONSTRAINT quest_achievement_ranking_statuses_channel_id_not_empty CHECK (channel_id <> '')
);

CREATE UNIQUE INDEX quest_achievement_ranking_statuses_channel_id_quest_achievement_ranking_id_uniq_idx ON quest_achievement_ranking_statuses (channel_id, quest_achievement_ranking_id);
CREATE TRIGGER quest_achievement_ranking_statuses_before_update
BEFORE UPDATE ON quest_achievement_ranking_statuses
  FOR EACH ROW EXECUTE PROCEDURE update_updated_at_utc_column();
