CREATE TABLE IF NOT EXISTS quests_status(
  quest_id uuid REFERENCES quests (id) NOT NULL,
  channel_id varchar(255) NOT NULL,
  
  created_at_utc timestamp DEFAULT current_timestamp NOT NULL,
  updated_at_utc timestamp);

CREATE UNIQUE INDEX quests_status_quest_id_channel_id_uniq_idx ON quests_status (quest_id, channel_id);

CREATE TRIGGER quests_status_before_update
BEFORE UPDATE ON quests_status
  FOR EACH ROW EXECUTE PROCEDURE update_updated_at_utc_column();

CREATE INDEX quests_status_channel_id_idx ON quests_status (channel_id);
CREATE INDEX quests_status_quest_idx ON quests_status (quest_id);

CREATE INDEX quest_achievement_ranking_statuses_channel_id_idx ON quest_achievement_ranking_statuses (channel_id);
CREATE INDEX quest_achievement_ranking_statuses_quest_achievement_ranking_id_idx ON quest_achievement_ranking_statuses (quest_achievement_ranking_id);