#!/usr/bin/env node
import cdk = require("@aws-cdk/core");
import { prod } from "./prod";
import { staging } from "./staging";
import { EnableTerminationProtection } from "../lib/termination-protection";

const env = {
  account: "989470033077", // twitch-cb-aws
  region: "us-west-2",
};

const app = new cdk.App();
cdk.Aspects.of(app).add(new EnableTerminationProtection());

if (app.node.tryGetContext("stage") == "prod") {
  prod(app, env);
} else {
  staging(app, env);
}
