import cdk = require("@aws-cdk/core");
import { VPCStack } from "../lib/vpc-stack";
import { TahoeTap } from "../lib/tahoe-tap-stack";
import { RedshiftStack } from "../lib/redshift-stack";

// Stage and Prod share an AWS account
const createStackID = (name: string) => `prod-Achievements-${name}`;

// Tahoe Tap names have to be unique
const createTahoeTapName = (version: number) =>
  `prod-achievements-tahoe-tap-v${version}`;

export const prod = (app: cdk.App, env: cdk.Environment) => {
  const vpcStack = new VPCStack(app, createStackID("VPC"), {
    env,
    vpcID: "vpc-7851b71e",
  });

  const redshiftClusterStack = new RedshiftStack(
    app,
    createStackID("TahoeTapRedshift"),
    {
      env,
      vpcStack,
      clusterName: "prod-achievements-tahoe-tap",
    },
  );

  new TahoeTap(app, createStackID("TahoeTapConnection"), {
    env,
    vpcStack,
    redshiftCluster: redshiftClusterStack.cluster,
    tapName: createTahoeTapName(1),
  });
};
