import cdk = require("@aws-cdk/core");
import { VPCStack } from "../lib/vpc-stack";
import { TahoeTap } from "../lib/tahoe-tap-stack";
import { RedshiftStack } from "../lib/redshift-stack";
import { CleanTapValidatorStack } from "../lib/clean-tap-validator-stack";

// Stage and Prod share an AWS account
const createStackID = (name: string) => `staging-Achievements-${name}`;

// Tahoe Tap names have to be unique
const createTahoeTapName = (version: number) =>
  `staging-achievements-tahoe-tap-v${version}`;

export const staging = (app: cdk.App, env: cdk.Environment) => {
  const vpcStack = new VPCStack(app, createStackID("VPC"), {
    env,
    vpcID: "vpc-7851b71e",
  });

  const redshiftClusterStack = new RedshiftStack(
    app,
    createStackID("TahoeTapRedshift"),
    {
      env,
      vpcStack,
      clusterName: "staging-achievements-tahoe-tap",
    },
  );

  new TahoeTap(app, createStackID("TahoeTapConnection"), {
    env,
    vpcStack,
    redshiftCluster: redshiftClusterStack.cluster,
    tapName: createTahoeTapName(11),
  });

  new CleanTapValidatorStack(app, createStackID("CleanTapValidator"), {
    env,
    vpcStack: vpcStack,
  });
};
