import * as cdk from "@aws-cdk/core";
import * as redshift from "@aws-cdk/aws-redshift";
import * as tap from "@twitch-cdk/tahoe-tap";
import { VPCStack } from "../vpc-stack";

// Choose from a list of views on https://taproom.di.twitch.a2z.com/
const views: string[] = [
  "spade.minute_broadcast",
  "spade.channel_concurrents",
  "spade.server_follow",
  "spade.raid_execute",
  "spade.server_chat_message",

  // De-anonymization (mapping) tables
  "mappingtable.ip",
  "mappingtable.otherid",
  "mappingtable.sessionid",
  "mappingtable.userid",
];

interface TahoeTapProps extends cdk.StackProps {
  vpcStack: VPCStack;
  redshiftCluster: redshift.Cluster;

  /**
   * Tap name that will populate Taproom
   */
  tapName: string;
}

export class TahoeTap extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: TahoeTapProps) {
    super(scope, id, props);

    new tap.Connection(this, "Connection", {
      // https://bindles.amazon.com/software_app/TwitchAchievementsTahoe
      bindleId: "amzn1.bindle.resource.lgzeu5u7wujhhrfw5u6a",
      purpose: "Achievements Tahoe Tap",
      tapName: props.tapName,
      vpc: props.vpcStack.vpc,
      subnets: props.vpcStack.privateSubnets,
      cluster: props.redshiftCluster,
      views,
    });
  }
}
