import * as cdk from "@aws-cdk/core";

interface MutableStack extends cdk.Stack {
  // Override `readonly` property of terminationProtection so we can modify it
  terminationProtection: boolean;
}

export class EnableTerminationProtection implements cdk.IAspect {
  visit(construct: cdk.IConstruct): void {
    if (cdk.Stack.isStack(construct)) {
      (construct as MutableStack).terminationProtection = true;
    }
  }
}
