package achievements

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/achievements/view"
	"code.justin.tv/foundation/twitchclient"
)

// GetAchievements makes a GET request to the Achievements Service for
// a given channel's achievements.
func (c *client) GetAchievements(ctx context.Context, channelID string, viewerID string, reqOpts *twitchclient.ReqOpts) (*view.Achievements, error) {
	path := fmt.Sprintf("/v1/internal/channel/%s/viewer/%s/achievements", channelID, viewerID)

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-achievements.v1.get_achievements",
		StatSampleRate: 0.1,
	})

	response := &view.Achievements{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
