package achievements

import (
	"context"

	"code.justin.tv/cb/achievements/view"
	"code.justin.tv/foundation/twitchclient"
)

// Client is the client interface for the Achievements service.
type Client interface {
	GetAchievements(ctx context.Context, channelID string, viewerID string, reqOpts *twitchclient.ReqOpts) (*view.Achievements, error)
	PostV1StreamManagerVisited(ctx context.Context, channelID, viewerID string, reqOpts *twitchclient.ReqOpts) (*view.V1StreamManagerVisitedResponse, error)
}

type client struct {
	twitchclient.Client
}

// NewClient instantiates a new client for the Achievements service.
func NewClient(config twitchclient.ClientConf) (Client, error) {
	if config.TimingXactName == "" {
		config.TimingXactName = "cb-achievements"
	}

	twitchClient, err := twitchclient.NewClient(config)
	if err != nil {
		return nil, err
	}

	return &client{twitchClient}, nil
}
