package achievements

import (
	"testing"

	"code.justin.tv/foundation/twitchclient"
	"github.com/stretchr/testify/suite"
)

type clientSuite struct {
	suite.Suite
}

func (s *clientSuite) TestError() {
	_, err := NewClient(twitchclient.ClientConf{})
	s.Error(err, "error expected from no host")
}

func (s *clientSuite) TestSuccess() {
	_, err := NewClient(twitchclient.ClientConf{Host: "test-host"})
	s.NoError(err)
}

func TestClientSuite(t *testing.T) {
	suite.Run(t, &clientSuite{})
}
