package achievements

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/achievements/view"
	"code.justin.tv/foundation/twitchclient"
)

// PostV1StreamManagerVisited makes a POST request to the Achievements Service for
// a given channel's "it begins" quest
func (c *client) PostV1StreamManagerVisited(ctx context.Context, channelID, viewerID string, reqOpts *twitchclient.ReqOpts) (*view.V1StreamManagerVisitedResponse, error) {
	path := fmt.Sprintf("/v1/internal/channel/%s/viewer/%s/streamManagerVisited", channelID, viewerID)

	req, err := c.NewRequest(http.MethodPost, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-achievements.v1.post_stream_manager_visited",
		StatSampleRate: 0.1,
	})

	response := &view.V1StreamManagerVisitedResponse{}

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
