## Deploying Achievements
Deployment is done using [clean-deploy](https://deploy.xarth.tv/#/cb/achievements).

1. Create a new branch for a feature in [cb/achievements](https://git.xarth.tv/cb/achievements).
2. After writing your feature, you can test locally by running `make dev-api` and making calls to `localhost`.
3. Using clean-deploy, deploy your branch to the Achievements Staging environment and test it. Errors can be found logged to [Rollbar](https://rollbar.com/Twitch/CB_Achievements/items/), or, if you prefer, in the slack channel #cb-deploys.
4. Create a pull request for your branch. You can ask in the slack channels #dashboard-feedback or #creator-business for a review.
5. After your PR is approved, merge your branch and deploy master to production using clean-deploy. You can test from the achievements dashboard on twitch (`:channel_login/dashboard/achievements`), or by calling Achievements directly. Production errors are still logged in [Rollbar](https://rollbar.com/Twitch/CB_Achievements/items/).
6. Verify that the Elastic Beanstalk application is healthy by visiting the [dashboard](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-achievements-production).

## Rollbacks
The fastest way to rollback a change is to use clean-deploy. Click the arrow next to the master branch, and select a previous version of the application. Deploy that version to production to rollback a change.
Make sure to make a new pull request to either fix your error, or revert the change. During this time, it's probably a good idea to freeze Achievements from any deployments to make sure your broken change is not re-deployed. You can freeze the project from clean-deploy by clicking the `freeze achievements` button in the top right corner.

## Failed Deployment
Often times when deploying, the sourcer's build will fail due to a failed health check:

![failed health check image](./img/failed_health_check.png)

When this happens, rebuild the build on the left hand side, and the build should succeed, and the deploy can be marked as a success.

![failed health check image](./img/rebuild.png)
