# Achievements Design and Architecture

## Table of Contents
1. [Functionality](#functionality)
2. [Architecture](#architecture)
3. [Project Organization](#project-organization)

## Functionality
The Achievements project handles gathering data, aggregating and updating broadcaster achievements. It also runs a separate
aggregation for multi-requirement achievements, which are known internally as quests. At a high level, achievements manages the following:

1. Infrastructure to read kinesis firehose data and insert it into redshift.
2. Query redshift clusters and aggregate data.
3. Analyze the results of redshift queries to determine if achievements/quests are completed.
4. Invite eligible broadcasters to the affiliate program, if they qualify.
5. Save aggregated progress into a database, to be served on the achievements dashboard page.
6. Provide an API to serve achievements data.

## Architecture

![Achievements Architecture](./ach_arch.png)

## Project Organization

Achievements are completed based on user-driven events. The Achievements system consists of the following services:

- `internal/affiliateinviter`: Handles failed Affiliate program invites, as well as re-sending invites when a user becomes eligible at a later time.

- `internal/affiliateworker`: Beanstalk worker environment that listens for SQS messages indicating payments workflow completion.

- `internal/api`: REST endpoints for exposing Achievement/Quest progressions.

- `internal/sourcer`: Consists of cron and listeners that transform external events into Achievement events for `worker` to handle.

- `internal/quests`: Aggregates metrics and events in order to determine when multiple criteria have been met. Also send rewards to users when the relevant criteria is met.

- `internal/worker`: Receives messages from the event `sourcer` to persist Achievement progressions.

