# Adding a new ingest event

The relevant terraform files for setting up a new firehose stream are `data-ingest.tf` and the `spade_ingest` module.

## Setting up the new Firehose stream stream
Add the following to `data-ingest.tf`:
```
module "YOUR_STREAM_NAME" {
  source = "./spade_ingest"
  redshift_configuration = "${data.null_data_source.redshift_configuration.inputs}"
  event_name = "YOUR_EVENT_NAME"
}
```

## Writing to the new Firehose stream
- Ping scieng with a request to add a new kinesis stream
- Provide the following info to science:

```
account number
	989470033077
team name
	cb-achievements
contact info
	Creator Business <creatorbusiness@justin.tv>
stream name
	spade-downstream-prod-cb-achievements-putter-{YOUR_ENV}
stream role ARN
	arn:aws:iam::989470033077:role/spade-downstream-prod-cb-achievements-putter-{YOUR_ENV}
compress
	N
```

And the following information about the stream:
event

- stream name
- spade event name

Confirm that the stream is writing to S3


### Creating the Redshift to table
- Create the table in redshift
	- if the schema doesn't exist, create the schema first `create schema logs`


### Reading from Redshift
[Developing with Redshift](redshift.md)
