# Notifications

When a quest or notification is completed, an onsite notification is sent via [DART](https://dart.osiris.xarth.tv).

- [Achievement Complete](https://dart.osiris.xarth.tv/messages/view/273c2d7d-955c-4840-b207-b91905e732d5)
- [Quest Complete](https://dart.osiris.xarth.tv/messages/view/0f8ba354-abd0-4d3a-a2d2-0d0e239501d3)

## Integration Testing

Below are the instructions for validating that onsite notifications show up on the Twitch website.

* You must be connected to the Twitch VPN in order to complete the steps below.
* You must use a channel_id that belongs to a staff account.
* You probably want to use your own channel_id so that you can see the onsite notification.

In order to see onsite notifications on https://twitch.tv, you must update config/staging.yml to use the production DART receiver host.

If you are testing a new NotificationType, campaign, message, etc. then you will need to update the dart client.

* Update internal/clients/dart/dart.go isTestSend to true.
* Update internal/clients/dart/dart.go to use a new NotificationType.

### Achievement Complete

```sh
curl -X POST -I 'cb-achievements-staging-api.us-west-2.elasticbeanstalk.com/notifications/publish?notification=achievement_complete&achievement=talk_a_little&channel_id=141594393'
```

### Quest Complete

```sh
curl -X POST -I 'cb-achievements-staging-api.us-west-2.elasticbeanstalk.com/notifications/publish?notification=quest_complete&quest=path_to_affiliate&channel_id=141594393'
```
