# Useful SQL Statements

## Postgres queries

### Connecting to Postgres

Look in 1Password for the password under the `achievements_01` user.

Make sure you are using the Twitch VPN.

```$xslt
> ./scripts/postgres-session prod
> psql -h cb-achievements-production-aurora.cluster-cqyyxr1hxrhn.us-west-2.rds.amazonaws.com -U achievements_01 -d achievements
```

Another approach is to open a session on a BastionHost EC2 instance within the `twitch-cb-aws` AWS console, and install `psql` with this command (if it's not already installed):

```
sudo amazon-linux-extras install postgresql10
psql -h cb-achievements-production-aurora.cluster-cqyyxr1hxrhn.us-west-2.rds.amazonaws.com -U achievements_01 -d achievements
```

### Complete the twitchcon achievement for a single user in production

```sql
-- COMPLETE TWITCHCON
INSERT INTO progressions (channel_id, achievement_id, progress, completed_at_utc)
VALUES (<channel_id>, 'c2182775-d995-4eb6-9f55-98a20f4e49b0', 1, current_timestamp);
```

### Complete "It's Happening" (first stream) achievement for a single user in production

```sql
-- COMPLETE FIRST STREAM
INSERT INTO progressions (channel_id, achievement_id, progress, completed_at_utc)
VALUES (<channel_id>, '6a13e3e3-1145-402a-9df7-30e106e31c19', 1, current_timestamp);
```

### Complete "Name of the Game" achievement for a single user in production

```sql
-- COMPLETE NAME OF THE GAME
INSERT INTO progressions (channel_id, achievement_id, progress, completed_at_utc)
VALUES ('413607686', '3333f4d5-d772-4f77-8ed5-7c5f04e2aa97', 1, current_timestamp);
```

### Complete "Know Your Stuff" achievement for a single user in production

```sql
-- COMPLETE KNOW YOUR STUFF
INSERT INTO progressions (channel_id, achievement_id, progress, completed_at_utc)
VALUES (<channel_id>, 'f9b15f5f-7c67-4dc1-b93a-e28bed01af19', 1, current_timestamp);
```

### Complete "We Belong" achievement for a single user in production

```sql
-- COMPLETE WE BELONG
INSERT INTO progressions (channel_id, achievement_id, progress, completed_at_utc)
VALUES (<channel_id>, 'ecbad324-4f21-4346-bd90-5ce4910ba719', 1, current_timestamp);
```

### Select achievement progress for a single user

```sql
SELECT
  a.key,
  p.channel_id,
  MAX(p.progress)
FROM achievements AS a
JOIN
  (
    SELECT *
    FROM progressions
  ) AS p
  ON p.achievement_id = a.id
where p.channel_id=<channel_id>
group by a.key, p.channel_id, p.completed_at_utc
order by p.completed_at_utc;
```

## Redshift Queries

### Select 30 day average ccu for a single user

```sql
WITH average_ccu_in_window AS
(
    SELECT a.channel_id
    , avg(b.total::float) AS average_ccu
    , count(a.channel_id) AS minutes_broadcast
    FROM logs.minute_broadcast a
    LEFT JOIN logs.channel_concurrents b
    ON a.channel_id = b.channel_id AND date_trunc('minute', a.time_utc) = date_trunc('minute', b.time_utc)
    WHERE a.time_utc > GETDATE() - interval '30 day'
    AND   (a.broadcaster_software IS NULL OR (a.broadcaster_software <> 'watch_party'
                                            AND a.broadcaster_software <> 'watch_party_rerun'
                                            AND a.broadcaster_software <> 'watch_party_premiere')
    )
    AND a.channel_id = <channel_id>
    GROUP BY a.channel_id
)

SELECT channel_id,
       average_ccu
FROM   average_ccu_in_window
WHERE  minutes_broadcast > 60
ORDER  BY average_ccu DESC;
```
