## Achievements Runbook
This describes the different components of Achievements and how to operate them.

[twitch-cb-aws account](https://twitch-cb-aws.signin.aws.amazon.com/console)

[Pagerduty](https://twitchoncall.pagerduty.com/services/P91KRCI)

[SLA](./service_level_agreement.md)

[Github](https://git.xarth.tv/cb/achievements)

[clean-deploy](https://deploy.xarth.tv/#/cb/achievements)

### Deploying and Rollbacks
See the deployment [docs](https://git.xarth.tv/cb/achievements/tree/master/docs/deployment.md) for help with deploying and rolling back.

### Monitoring and Errors
Errors are logged to [rollbar](https://rollbar.com/Twitch/CB_Achievements/items/).
There is a Grafana dashboard [here](https://grafana.xarth.tv/d/000001322/achievements?var-Datasource_graphite=grafanacloud-prodeng-graphite).
Beanstalk apps can also be monitored from the AWS console:

1. [Production](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-achievements-production)
2. [Staging](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-achievements-staging)

### Pagerduty
[Pagerduty](https://twitchoncall.pagerduty.com/services/P91KRCI)
Pagerduty is integrated with both Cloudwatch and rollbar. Pages are sent based on error rates and application health.

### Terraform
Infrastructure configuration is done using terraform. All these files live in the [git repo](https://git.xarth.tv/cb/achievements/tree/master/terraform). Changes should be applied to both staging and production, and committed to the repo using a pull request.

### Elastic Beanstalk
Achievements exists as an elastic beanstalk application, for both staging and production environments.

1. [Production](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-achievements-production)
2. [Staging](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/application/overview?applicationName=cb-achievements-staging)

### RDS
Achievements is backed by a postgres database to store achievement completions and progressions.

1. [production](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-achievements-production-5)
2. [staging](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-achievements-staging-2)

Each database also has a single read replica in RDS.

1. [production](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-achievements-production-replica-5)
2. [staging](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-achievements-staging-replica-2)

Configuration for these databases can be found in the terraform files mentioned in the previous section.

### DynamoDB
There are a number of dynamo tables used, especially in tracking quest progress/completions. Each of the following tables also has an equivalent in staging.

1. [cb-achievements-feature-flags](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-feature_flags;tab=overview) controls feature flagging for the project.
2. [cb-achievements-production-quest_progress](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-production-quest_progress;tab=overview) stores progress towards quest completion for every channel.
3. [cb-achievements-production-quest_completions](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-production-quest_completions;tab=overview) stores channels who have completed various quests.
4. [cb-achievements-production-it_begins_progress](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-production-it_begins_progress;tab=overview) stores progress towards the It Begins quest. It Begins is stored separately from other quests because the requirements are strictly sns based and dont require aggregation, so this allows us to award the quest in realtime.
5. [cb-achievements-production-first_streams](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-production-first_streams;tab=overview) stores channels who have completed the first stream achievement.
6. [cb-achievements-production-first_dashboard_accesses](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-production-first_dashboard_accesses;tab=overview) stores channels who have completed the dashboard access achievement.
7. [cb-achievements-production-failed_affiliate_invites](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-production-failed_affiliate_invites;tab=overview) stores failed affiliate invites for a later lookup, so we can better automate re-inviting potential affiliates if their initial invite failed or was blocked by existing payments onboarding.
8. [cb-achievements-production-channel_updates](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:selected=cb-achievements-production-channel_updates;tab=overview) stores channels with updates to their game/community and stream title.

### Cloudwatch
Application health for each beanstalk application is monitored through Cloudwatch.
1. [Sourcer health](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-achievements-production-sourcer-health)
2. [API health](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-achievements-production-api-health)
3. [Worker health](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarm:alarmFilter=ANY;name=cb-achievements-production-worker-health)

### Past Alarms
See the docs for [alarms](./alarms.md)

### Credentials

Credentials for all Redshift and RDS clusters are in the Creator Analytics 1password team vault.
