# Useful Scripts
In the [scripts directory](https://git.xarth.tv/cb/achievements/tree/master/scripts), in addition to build and deploy scripts, there are a number of scripts that have been run to fill in data or to provide some missing functionality.

Additional documentation and usage instructions for these scripts is provided inline. Before running any scripts, consult the inline documentation as well!

## backfill_talk_a_little
`Talk a Little` was a new achievement launched with the VIP Badges feature. In order to unlock VIPs, the achievement needs to be completed. The requirements for `Talk a Little` are to get 10 concurrent chatters. `Talk to Me` requires 25 concurrent chatters, therefore any existing broadcasters that have completed `Talk to Me` should have `Talk a Little` completed when it launched.

This script checks all channels that have completed the first level of `Talk to Me` and completes all three levels of `Talk a Little` for them.

## backfill_vip_badge
When VIP badges launched, we needed to complete this quest for all users who had already met the requirements (for example, all actively streaming partnered accounts). This would ensure that the quest was completed immediately upon launch so broadcasters wouldn't be confused as to why they had not completed the quest yet.

We select all channels that meet the progress requirements and then insert them into the quest completions dynamodb table.

## migrate_it_begins_quest_completions
When quests was migrated to a new `quest_completions` dynamodb table, existing completions data needed to be inserted into it to complete the transfer. `It Begins` was originally implemented separately from other quests, because it relies on SNS events and not analytics data from redshift. This script scans dynamodb for all existing `It Begins` quest completions and inserts them into the `quest_completions` table.

This was intended as a one-off script.

## migrate_it_begins_quest_progress
Similar to `migrate_it_begins_quest_completions`, this reads all existing `It Begins` progress and writes it to the `quest_progress` dynamodb table.

This was intended as a one-off script.

## reinvite_failed_affiliates
As mentioned in the [quirks](./quirks.md) docs, when affiliate invites fail the error is stored in the `failed_affiliate_invites` dynamodb table. There is a beanstalk app to listen for payments SNS messages to clear these errors, but occasionally errors occur that can't be automatically fixed. In this past, this has included LDAP failures or moneypenny outages.

In these cases, this script can be run to scan all the existing errors and re-send affiliate invitation requests for those channels. It is intended to be run whenever a batch of invites fail and can't be re-sent automatically.

1. Start the bastion proxy: `scripts/bastion-proxy`
3. HTTP_PROXY=socks5://localhost:1080 AWS_PROFILE=twitch-cb-aws go run scripts/reinvite_failed_affiliates/main.go

## send_affiliate_invites
At some point, we failed to send 100% of affiliate invites due to database problems. To fix this outage, this script was written to select all channels that had qualified for affiliate and then re-send invite for them.

This script is now outdated, because `Path to Affiliate` progress is stored in dynamodb, and not rds, as was the case when the script was written. It has not been used since, but could be repurposed to scan the dynamodb `quest_completions` table to re-send invites again.
