package broadcastnhours30days

import (
	"encoding/json"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/clients/db"
	log "github.com/sirupsen/logrus"
)

// Key for this job
const Key = "broadcast_n_hours_30_days"

// Input contains the required fields to process this Achievement.
type Input struct {
	Broadcasts []*Broadcasts `json:"broadcasts"`
}

// Broadcasts defines the minutes broadcast for a channel id
type Broadcasts struct {
	ChannelID string `json:"channel_id"`
	Minutes   int    `json:"minutes"`
}

// Job is the job struct for this achievement
type Job struct {
	Clients    *achievement.Clients
	Broadcasts []*Broadcasts
}

// InitJob creates new job to will handle a first stream event
func InitJob(clients *achievement.Clients, input []byte) *Job {
	parsed := Input{}
	if err := json.Unmarshal(input, &parsed); err != nil {
		log.Error(err)
	}

	return &Job{
		Clients:    clients,
		Broadcasts: parsed.Broadcasts,
	}
}

// GetProgressions calculates the db progressions model from the achievement group
func (j *Job) GetProgressions(group db.AchievementGroup) []db.Progression {
	progressions := []db.Progression{}

	for _, broadcast := range j.Broadcasts {
		channelProgressions := group.NewChannelProgressions(broadcast.ChannelID, broadcast.Minutes)
		progressions = append(progressions, channelProgressions...)
	}
	return progressions
}

// Key returns the key for this achievement
func (j *Job) Key() string {
	return Key
}

// ProgressRelapsable specifies whether the Achievement is windowed, thus the progress can go down over time.
func (j *Job) ProgressRelapsable() bool {
	return true
}
