package broadcastnhours30days_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/broadcastnhours30days"

	"github.com/stretchr/testify/suite"
)

type broadcastNHours30DaysSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"broadcasts": [{
			"channel_id": "%s",
			"minutes": %d}
		]}`, testChannelID, testNumber))

	s := &broadcastNHours30DaysSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *broadcastNHours30DaysSuite) TestInitJob() {
	j := broadcastnhours30days.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*broadcastnhours30days.Broadcasts{
		{
			ChannelID: testChannelID,
			Minutes:   testNumber,
		},
	}, j.Broadcasts)
}
