package firststream_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/firststream"

	"github.com/stretchr/testify/suite"
)

type firstStreamSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{"channel_id": "%s"}`, testChannelID))

	s := &firstStreamSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *firstStreamSuite) TestInitJob() {
	j := firststream.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal(testChannelID, j.ChannelID)
}
