package nbroadcastdays30days

import (
	"encoding/json"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/clients/db"
	log "github.com/sirupsen/logrus"
)

// Key for this job
const Key = "n_broadcast_days_30_days"

// Input contains the required fields to process this Achievement.
type Input struct {
	Channels []*ChannelUniqueDayCount `json:"channels"`
}

// ChannelUniqueDayCount is the number of unique dow the specified channel has
// broadcast in the last 30 days
type ChannelUniqueDayCount struct {
	ChannelID  string `json:"channel_id"`
	UniqueDays int    `json:"unique_days"`
}

// Job is the job struct for this achievement
type Job struct {
	Clients  *achievement.Clients
	Channels []*ChannelUniqueDayCount
}

// InitJob creates new job to will handle a first stream event
func InitJob(clients *achievement.Clients, input []byte) *Job {
	parsed := Input{}
	if err := json.Unmarshal(input, &parsed); err != nil {
		log.Error(err)
	}

	return &Job{
		Clients:  clients,
		Channels: parsed.Channels,
	}
}

// Key returns the key for this achievement
func (j *Job) Key() string {
	return Key
}

// GetProgressions calculates the db progressions model from the achievement group
func (j *Job) GetProgressions(group db.AchievementGroup) []db.Progression {
	progressions := []db.Progression{}

	for _, channel := range j.Channels {
		channelProgressions := group.NewChannelProgressions(channel.ChannelID, channel.UniqueDays)
		progressions = append(progressions, channelProgressions...)
	}
	return progressions
}

// ProgressRelapsable specifies whether the Achievement is windowed, thus the progress can go down over time.
func (j *Job) ProgressRelapsable() bool {
	return true
}
