package nbroadcastdays30days_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/nbroadcastdays30days"

	"github.com/stretchr/testify/suite"
)

type nBroadcastDays30DaysSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"unique_days": %d}
		]}`, testChannelID, testNumber))

	s := &nBroadcastDays30DaysSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nBroadcastDays30DaysSuite) TestInitJob() {
	j := nbroadcastdays30days.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*nbroadcastdays30days.ChannelUniqueDayCount{
		{
			ChannelID:  testChannelID,
			UniqueDays: testNumber,
		},
	}, j.Channels)
}
