package nconcurrents30days_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/nconcurrents30days"

	"github.com/stretchr/testify/suite"
)

type nConcurrents30Days struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"average_ccu": %d}
		]}`, testChannelID, testNumber))

	s := &nConcurrents30Days{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nConcurrents30Days) TestInitJob() {
	j := nconcurrents30days.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*nconcurrents30days.ChannelAverageConcurrentViewers{
		{
			ChannelID:  testChannelID,
			AverageCCU: testNumber,
		},
	}, j.Channels)
}
