package ndaysnoviewers_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/ndaysnoviewers"

	"github.com/stretchr/testify/suite"
)

type nDaysNoViewersSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"consecutive_sessions": %d}
		]}`, testChannelID, testNumber))

	s := &nDaysNoViewersSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nDaysNoViewersSuite) TestInitJob() {
	j := ndaysnoviewers.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*ndaysnoviewers.ChannelConsecutiveSessionsNoViewers{
		{
			ChannelID:           testChannelID,
			ConsecutiveSessions: testNumber,
		},
	}, j.Channels)
}
