package nfollowers_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/nfollowers"

	"github.com/stretchr/testify/suite"
)

type nFollowersSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"follow_count": %d}
		]}`, testChannelID, testNumber))

	s := &nFollowersSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nFollowersSuite) TestInitJob() {
	j := nfollowers.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*nfollowers.ChannelFollowers{
		{
			ChannelID:   testChannelID,
			FollowCount: testNumber,
		},
	}, j.Channels)
}
