package nhourslifetime_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/nhourslifetime"

	"github.com/stretchr/testify/suite"
)

type nHoursLifetimeSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"minutes_broadcast": %d}
		]}`, testChannelID, testNumber))

	s := &nHoursLifetimeSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nHoursLifetimeSuite) TestInitJob() {
	j := nhourslifetime.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*nhourslifetime.ChannelMinutesBroadcast{
		{
			ChannelID:        testChannelID,
			MinutesBroadcast: testNumber,
		},
	}, j.Channels)
}
