package nminutewatchedlifetime_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/nminutewatchedlifetime"

	"github.com/stretchr/testify/suite"
)

type nMinuteWatchedLifetimeSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"minutes_watched": %d}
		]}`, testChannelID, testNumber))

	s := &nMinuteWatchedLifetimeSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nMinuteWatchedLifetimeSuite) TestInitJob() {
	j := nminutewatchedlifetime.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*nminutewatchedlifetime.ChannelMinutesWatched{
		{
			ChannelID:      testChannelID,
			MinutesWatched: testNumber,
		},
	}, j.Channels)
}
