package nuniquechatterbroadcast_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/nuniquechatterbroadcast"

	"github.com/stretchr/testify/suite"
)

type nUniqueChatterBroadcast struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"unique_logins": %d}
		]}`, testChannelID, testNumber))

	s := &nUniqueChatterBroadcast{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nUniqueChatterBroadcast) TestInitJob() {
	j := nuniquechatterbroadcast.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*nuniquechatterbroadcast.ChannelUniqueChatters{
		{
			ChannelID:    testChannelID,
			UniqueLogins: testNumber,
		},
	}, j.Channels)
}
