package nviewerslifetime_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/nviewerslifetime"

	"github.com/stretchr/testify/suite"
)

type nViewersLifetimeSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"
const testNumber = 1

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{
		"channels": [{
			"channel_id": "%s",
			"max_viewers": %d
		}
		]}`, testChannelID, testNumber))

	s := &nViewersLifetimeSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *nViewersLifetimeSuite) TestInitJob() {
	j := nviewerslifetime.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal([]*nviewerslifetime.ChannelMaxConcurrentViewers{
		{
			ChannelID:  testChannelID,
			MaxViewers: testNumber,
		},
	}, j.Channels)
}
