package singlebroadcasttitle_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/singlebroadcasttitle"

	"github.com/stretchr/testify/suite"
)

type singleBroadcastTitleSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{"channel_id": "%s"}`, testChannelID))

	s := &singleBroadcastTitleSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *singleBroadcastTitleSuite) TestInitJob() {
	j := singlebroadcasttitle.InitJob(s.clients, s.input)
	s.Equal(s.clients, j.Clients)
	s.Equal(testChannelID, j.ChannelID)
}
