package singledashboardvisit_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/mocks"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/singledashboardvisit"

	"github.com/stretchr/testify/suite"
)

type singleDashboardVisitSuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{"channel_id": "%s"}`, testChannelID))

	s := &singleDashboardVisitSuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *singleDashboardVisitSuite) TestInitJob() {
	j := singledashboardvisit.InitJob(s.clients, s.input)
	s.Equal(j.Clients, s.clients)
	s.Equal(j.ChannelID, testChannelID)
}
