package singleselectgamecommunity_test

import (
	"fmt"
	"testing"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/achievement/singleselectgamecommunity"
	"code.justin.tv/cb/achievements/internal/mocks"
	"github.com/stretchr/testify/suite"
)

type singleSelectGameCommunitySuite struct {
	suite.Suite
	clients *achievement.Clients
	input   []byte
}

const testChannelID = "test channel id"

func TestAchievementSuite(t *testing.T) {
	bytes := []byte(fmt.Sprintf(`{"channel_id": "%s"}`, testChannelID))

	s := &singleSelectGameCommunitySuite{
		clients: &achievement.Clients{
			DBReader: &mocks.Reader{},
			DBWriter: &mocks.Writer{},
		},
		input: bytes,
	}

	suite.Run(t, s)
}

func (s *singleSelectGameCommunitySuite) TestInitJob() {
	j := singleselectgamecommunity.InitJob(s.clients, s.input)
	s.Equal(j.Clients, s.clients)
	s.Equal(j.ChannelID, testChannelID)
}
