package talkalittle

import (
	"encoding/json"

	"code.justin.tv/cb/achievements/internal/achievement"
	"code.justin.tv/cb/achievements/internal/clients/db"

	chatters "code.justin.tv/cb/achievements/internal/achievement/nuniquechatterbroadcast"
	log "github.com/sirupsen/logrus"
)

// Key for this job
const Key = "talk_a_little"

// Job is the job struct for this achievement
type Job struct {
	Clients  *achievement.Clients
	Channels []*chatters.ChannelUniqueChatters
}

// InitJob creates new job to will handle an event
func InitJob(clients *achievement.Clients, input []byte) *Job {
	parsed := chatters.Input{}
	if err := json.Unmarshal(input, &parsed); err != nil {
		log.Error(err)
	}

	return &Job{
		Clients:  clients,
		Channels: parsed.Channels,
	}
}

// Key returns the key for this achievement
func (j *Job) Key() string {
	return Key
}

// GetProgressions calculates the db progressions model from the achievement group
func (j *Job) GetProgressions(group db.AchievementGroup) []db.Progression {
	progressions := []db.Progression{}

	for _, channel := range j.Channels {
		channelProgressions := group.NewChannelProgressions(channel.ChannelID, channel.UniqueLogins)
		progressions = append(progressions, channelProgressions...)
	}
	return progressions
}

// ProgressRelapsable specifies whether the Achievement is windowed, thus the progress can go down over time.
func (j *Job) ProgressRelapsable() bool {
	return false
}
