package api

import (
	"context"
	"fmt"
	"net/http"
	"strconv"

	"code.justin.tv/cb/achievements/internal/httputil"
	"goji.io/pat"
)

type contextKey int

const (
	//ContextKeyChannelID used for parsing channelID
	ContextKeyChannelID contextKey = iota
	ContextKeyViewerID
)

// ValidateChannelID will validate the channelID
func ValidateChannelID(inner http.Handler) http.Handler {
	middleware := func(w http.ResponseWriter, req *http.Request) {
		writer := httputil.NewJSONResponseWriter(w)
		channelID := pat.Param(req, "channel_id")

		_, err := strconv.Atoi(channelID)

		if err != nil {
			msg := fmt.Sprintf("Channel ID (%s) must be numeric", channelID)
			writer.BadRequest(msg)
			return
		}

		ctx := context.WithValue(req.Context(), ContextKeyChannelID, channelID)

		inner.ServeHTTP(w, req.WithContext(ctx))
	}

	return http.HandlerFunc(middleware)
}

// ValidateViewerID will validate the viewerID
func ValidateViewerID(inner http.Handler) http.Handler {
	middleware := func(w http.ResponseWriter, req *http.Request) {
		writer := httputil.NewJSONResponseWriter(w)
		viewerID := pat.Param(req, "viewer_id")

		_, err := strconv.Atoi(viewerID)

		if err != nil {
			msg := fmt.Sprintf("ViewerID ID (%s) must be numeric", viewerID)
			writer.BadRequest(msg)
			return
		}

		ctx := context.WithValue(req.Context(), ContextKeyViewerID, viewerID)

		inner.ServeHTTP(w, req.WithContext(ctx))
	}

	return http.HandlerFunc(middleware)
}
