package db

import (
	"context"
	"fmt"
	"strconv"
	"strings"

	log "github.com/sirupsen/logrus"
)

// InsertTwitchconAttendees inserts channel ids into the progressions table for each purchaser of a twitchcon ticket
func (db *Client) InsertTwitchconAttendees(ctx context.Context, attendees []string) error {
	// yikes
	var values strings.Builder
	for i, a := range attendees {
		if _, err := strconv.Atoi(a); err != nil {
			return fmt.Errorf("db: found non-numeric channel id in attendee list: %s", err)
		}

		if i == len(attendees)-1 {
			values.WriteString(fmt.Sprintf("(%s)", a))
		} else {
			values.WriteString(fmt.Sprintf("(%s),", a))
		}
	}

	statement := fmt.Sprintf(
		`WITH twitchcon_achievement AS (
             SELECT id FROM achievements WHERE key='single_twitchcon2017'
           ),

           attendees AS (
               SELECT DISTINCT * FROM (VALUES %s) AS list
           )

           INSERT INTO progressions (channel_id, achievement_id, progress, completed_at_utc)
           SELECT a.column1, ta.id, 1, NOW() FROM attendees a CROSS JOIN twitchcon_achievement ta
           ON CONFLICT DO NOTHING`, values.String())

	result, err := db.ExecContext(ctx, statement)
	if err != nil {
		return err
	}

	rows, err := result.RowsAffected()
	if err != nil {
		return err
	}

	if rows == 0 {
		log.Info("db: found no new twitchcon attendees to write")
	}

	return nil
}
