package db

import (
	"context"
)

// Reader reads from the database via SELECT.
type Reader interface {
	// SelectAllAchievementProgressionsForChannel gets all achievements,
	// joined with a channel's progression (can be null).
	SelectAllAchievementProgressionsForChannel(ctx context.Context, channelID string) ([]*Achievement, error)
	SelectAchievementsByKey(ctx context.Context, key string) ([]*Achievement, error)
}

// Writer writes to the database via INSERT or UPDATE.
type Writer interface {
	UpsertProgressions(ctx context.Context, params []Progression, progressRelapsable bool) ([]Progression, error)
	InsertTwitchconAttendees(ctx context.Context, attendees []string) error
}
