package dynamo

import (
	"context"
)

// Dynamo is the interface for interacting with achievement dynamo tables
type Dynamo interface {
	TableHasChannel(ctx context.Context, table string, channelID string) (bool, error)
	PersistChannelToTable(ctx context.Context, table string, channelID string) error
	GetChannelUpdate(ctx context.Context, channelID string) (*ChannelUpdate, error)
	SaveChannelUpdate(ctx context.Context, channelUpdate *ChannelUpdate) error
	IsFeatureEnabled(ctx context.Context, feature string) (bool, error)
}
